#!/bin/ksh
 
# The script will create a compressed tarball of your entire WordPress installation directory 
# (but not the database). The resulting file may be quite large, depending on how much stuff you 
# uploaded to your site. You will need to modify these two variables: $WORKDIR and $WWWHOME. With 
# most hosting providers, your WordPress installation will be located in /home/your_username/public_html. 
# You will also need to create the backup directory: /home/your_username/backups
 
# -----------------------
# FUNCTIONS
# -----------------------
 
configure() {
        WORKDIR="/home/your_username"
        WWWHOME="${WORKDIR}/public_html"
        BACKUPDIR="${WORKDIR}/backups"
        DATE=`/usr/bin/date +'%Y-%m-%d_%H-%M'`
        BACKUPFILE="public_html_backup_${DATE}.tar"
        LOG="${BACKUPDIR}/backup_site.log"
        if [ ! -d "${BACKUPDIR}" ]
        then
                mkdir "${BACKUPDIR}"
        fi
}
 
log() {
       LINELIM=1000 ; LINEBUF=50 ; LINEMAX=`echo "${LINELIM}+${LINEBUF}"|bc -l`
       if [ ! -r "$LOG" ]
       then
               touch "$LOG"
       fi
 
       if [ -f "$LOG" ] && [ `wc -l "$LOG" | awk '{print $1}'` -gt $LINEMAX ]
       then
               cat "$LOG" | tail -$LINELIM > "$TMP"
               mv "$TMP" "$LOG"
       fi
}
 
message() {
       if [ ! $TAIL ]
       then
               TAIL=1
       else
               TAIL=`echo "${TAIL}+1"|bc -l`
       fi
       echo "`hostname`        `date +'%Y-%m-%d %T'`   $MSG" >> "$LOG"
       tail -1 "$LOG"
}
 
verify() {
        STATUS=0
        for DIR in "${WORKDIR}" "${WWWHOME}" "${BACKUPDIR}"
        do
                if [ ! -d "${DIR}" ]
                then
                        MSG=`echo "ERROR: Directory ${DIR} not found."` ; message
                        STATUS=1
                fi
        done
 
        if [ $STATUS -ne 0 ]
        then
                echo "Backup encountered fatal error! Exiting..."
                exit $STATUS
        fi
}
 
backup() {
        tar -cvf ${BACKUPDIR}/${BACKUPFILE} ${WWWHOME}
 
        if [ $? -eq 0 ]
        then
                if [ -r "${BACKUPDIR}/${BACKUPFILE}" ]
                then
                        gzip "${BACKUPDIR}/${BACKUPFILE}"
                        if [ $? -eq 0 ]
                        then
                                MSG=`echo "INFO: Backup completed on $DATE"` ; message
                        else
                                MSG=`echo "ERROR: Backup failed on $DATE"` ; message
                        fi
                fi
        else
                MSG=`echo "ERROR: Backup failed on $DATE"` ; message
        fi
}
 
# -----------------------
# RUNTIME
# -----------------------
 
configure
log
message
verify
backup
