#!/bin/sh
#
# The following script will duplicate a Solaris boot disk. The script uses ufsdump/restore as opposed to dd, 
# so disks of different sizes can be used.
#
 
EMAIL=admin@domain.com
SUBJECT="Boot disk copy on `hostname`"
 
if [ "$#" != 2 ] ; then
  echo "usage: $0 sdisk tdisk"
  echo "where: sdisk is the source disk (e.g. c0t0d0)"
  echo "       tdisk is the target disk (e.g. c0t1d0)"
  echo "Note:  Please omit slice numbers!"
  exit 1
fi
 
format/dev/null 2>&1 && S=$1
format/dev/null 2>&1 && T=$2
if [ -z "$S" ] ; then
  echo "ERROR: Source disk $1 does not exist -- exit!" ; exit 2
elif [ -z "$T" ] ; then
  echo "ERROR: Target disk $2 does not exist -- exit!" ; exit 3
fi
 
#clear ; echo "
#  ATTENTION: This script will copy the whole disk $S to $T
#             If this is NOT what you intended to do, abort
#             by pressing Ctrl-C now!
#
#  Are you ready now [N] ? \c"
#read ans mist ; echo ""
#[ "$ans" != "J" -a "$ans" != "j" -a "$ans" != "Y" -a "$ans" != "y" ] && exit 1
 
prtvtoc /dev/rdsk/${S}s2|fmthard -s - /dev/rdsk/${T}s2     # copy VTOC
for i in `tail -r /etc/mnttab|grep /a|awk '{print $2}'`     # make sure nothing is
  do umount -f $i >/dev/null 2>&1               # mounted under /a ...
done
[ -d /a ] || mkdir /a                         # create /a if not here
 
SD=/dev/rdsk/$S ; TD=/dev/rdsk/$T               # the raw disk devices
fs=`df -kl | grep \`echo $SD | sed -e 's/rdsk/dsk/'\` | grep /dsk/ | sed -e 's/^.*\(s[0-9]* \).*/\1/'`     # fs on boot disk used
 
for i in $fs;do
  echo "creating file system on ${TD}$i ...\c"
  echo y | newfs ${TD}$i >/dev/null 2>&1 ; echo ""     # create filesystems
done
 
for i in $fs ; do                         # mount new disk under
 echo "copying all data from slice $S$i to $T$i ..."     # /a and copy all data
 M=/a`df -kl|grep ${S}$i|awk '{print $6}'|sed -e 's!/$!!'`
 F=`df -kl|grep ${S}$i|awk '{print $6}'`          # from source disk
 mount `echo ${TD}$i|sed -e 's/rdsk/dsk/'` $M          # to target disk
 ( /etc/init.d/xntpd stop ; sleep 30 ; /etc/init.d/xntpd start ) &
 ufsdump 0f - `fssnap -F ufs -o raw,bs=$M,unlink ${F}`| ( cd $M ; ufsrestore rf - ) >/dev/null 2>&1          # (using ufsdump
 fssnap -F ufs -d ${F} >/dev/null 2>&1               # with UFS snapshot)
 echo ""
done
 
# Okay, now let's make the new disk bootable:
installboot /usr/platform/`uname -m`/lib/fs/ufs/bootblk `df -kl /a | sed -ne 's/\(\/dev\/\)\(dsk\/[^      ]*\).*/\1r\2/p'`
 
# and modify the mount entries in /etc/vfstab on new disk:
sed -e "s/${S}/${T}/g" /etc/vfstab > /a/etc/vfstab
 
# send e-mail
echo "Boot disk copy $S to $T complete on `hostname`" | mailx -s "$SUBJECT" $EMAIL
