#!/bin/ksh
#
# The following Korn shell script will make a bootable copy of the boot disk on a Solaris system. The script 
# uses dd and requires that the source disk and destination disk have the same geometry.
#
 
####  Set some variables  ####
HOST=`hostname`
ROOT_USR=server_dudes
MAIL_SUB="Root disk copy on $HOST"
 
####  Set some flags  ####
MAIL_MSG=0
RETURN=0
LOOP=""
DD_DEVICE="0"           # for DD_DEVICE, 0 = do not issue the dd command to
                        # duplicate the partition configuration of SRC_DRV to
                        # DEST_DRV; 1 = issue dd command - assumes the SRC_DRV
                        # and DEST_DRV are identical disks
EDIT_VFSTAB=0           # for EDIT_VFSTAB, 0 = edit the vfstab file on
                        # DEST_DRV so system will boot off of that drive in
                        # that scsi location;  1 = don't edit the vfstab file
                        # (disks locations are swapped on those systems to
                        # boot off alternate)
 
#--------------------------------
# Define the source and destination devices for each system; set flags
#--------------------------------
if [ $HOST = "bobby" ]
then
  SRC_DRV="c1t1d0s"
  DEST_DRV="c1t2d0s"
  DD_DEVICE="1"
fi
 
#--------------------------------
# Define a couple of procedures
#--------------------------------
####  Send completion messages  ####
mail_msg() {
  case $MAIL_MSG in
        0) MESSAGE="Root copy successfully completed on `hostname`" ;;
        1) MESSAGE="Error copying $mp partition" ;;
        2) MESSAGE="Unable to remove root copy mount point. Still mounted." ;;
        3) MESSAGE="Destination Drive in use. Copy aborted. See /var/tmp/DEST_DRV" ;;
  esac
/usr/ucb/mail -s "$MAIL_SUB" $ROOT_USR << END
$MESSAGE
END
}
 
####  Exit code on completion ####
get_out() {
  exit $RETURN
}
 
#--------------------------------
# Check that none of the DEST_DRV partitions are mounted. Unmount if true.
# Check it twice in case two different temp mount points were used.
# If DEST_DRV still in use, record, abort and notify.
#--------------------------------
for count in 1 2
do
    for i in `df -kl | grep $DEST_DRV | awk '{print $6}' | sort -r`
    do
      umount $i
    done
done
 
df -kl | grep $DEST_DRV > /var/tmp/DEST_DRV
 
if [ $? -eq 0 ]
then
  MAIL_MSG=3 ; RETURN=3
  mail_msg
  get_out
fi
 
#--------------------------------
# Duplicate the partition information if disk geometries match:
#--------------------------------
if [ $DD_DEVICE -eq 1 ]
then
  echo "Running dd to create partition layout ..."
  # dd if=/dev/rdsk/${SRC_DRV}2 of=/dev/rdsk/${DEST_DRV}2 bs=1024k
  prtvtoc /dev/rdsk/${SRC_DRV}2 | fmthard -s - /dev/rdsk/${DEST_DRV}2
fi
 
#--------------------------------
# create the temporary alt root mount point if it doesn't exist
#--------------------------------
if [ ! -d /newroot ]
then
  echo "Creating mount point for root disk copy ..."
  mkdir /newroot
fi
 
#--------------------------------
# get the filesystems on the root drive & duplicate on the alt drive
#--------------------------------
for i in `df -kl | grep $SRC_DRV | grep ^/dev | awk '{print (substr($1,length($1),1))"."(substr($6,2))}' | sort`
do
  part=`echo $i | awk -F. '{print $1}'`              # disk slice to copy
  mp=`echo $i | awk -F. '{print $2}'`                # mount point
  echo "making filesystem for /newroot/$mp ..."
  echo y | newfs /dev/rdsk/$DEST_DRV$part
  if [ "$mp" != "" -a ! -d /newroot/$mp ]
  then
    mkdir /newroot/$mp
  fi
  mount /dev/dsk/$DEST_DRV$part /newroot/$mp
  echo "copying files for /newroot/$mp ..."
  cd /$mp ; find . -mount ! -type s | cpio -pmud /newroot/$mp
  # for some reason, the /dev/fd directory is not being transferred
  # so do it manually
  if [ "$mp" = "" -o "$mp" = "/" ]
  then
    mkdir /newroot/dev/fd
    chmod 555 /newroot/dev/fd
    touch /newroot/reconfigure  # we have to populate the new /dev/fd
  fi
  if [ $? != 0 ]
  then
    MAIL_MSG=1 ; RETURN=1
    mail_msg
    get_out
  fi
done
 
#--------------------------------
# install a boot block so this drive can boot
#--------------------------------
installboot /usr/platform/`uname -i`/lib/fs/ufs/bootblk /dev/rdsk/${DEST_DRV}0
mkdir /newroot/tmp ; chmod 777 /newroot/tmp
mkdir /newroot/proc
 
#--------------------------------
# if geometries are different we have to use the new disk in it's
# current location to boot from, so edit the vfstab file
#--------------------------------
if [ $EDIT_VFSTAB -eq 0 ]
then
  sed s/$SRC_DRV/$DEST_DRV/g /etc/vfstab > /newroot/etc/vfstab
fi
 
#--------------------------------
# make the directory structure on the alternate root
#--------------------------------
for LOOP in `df -k | grep $SRC_DRV | awk '{print $6}' | sort -r`
do
  if [ "x$LOOP" != "x" ]
  then
    mkdir -p /newroot$LOOP
    if [ $? != 0 ]
    then
      mkdir /newroot$LOOP
    fi
  fi
done
 
#--------------------------------
# create mount points for any additional filesystems
#--------------------------------
for other_mount in `df -kl | grep -v $DEST_DRV | grep -v $SRC_DRV | grep ^/dev | awk '{print $6}'`
do
  if [ "$other_mount" ]
  then
    mkdir -p /newroot$other_mount
  fi
done
 
#--------------------------------
# unmount all the alt root filesystems & delete the temporary mount point
#--------------------------------
for i in `df -kl | grep -v vx | grep newroot | awk '{print $6}' | sort -r`
do
  umount $i
done
 
df -kl | grep newroot > /dev/null 2>&1
 
if [ $? -ne 0 ]
then
  rmdir /newroot
else
  MAIL_MSG=2 ; RETURN=2
  mail_msg
  get_out
fi
 
mail_msg
get_out
