<?php
/**
 * Plugin Name: Diddle Widget
 * Plugin URI: http://www.krazyworks.com/support/diddle-widget-plugin/
 * Description: Server information and performance analysis widget based on the diddle.ksh script by <a href="http://www.krazyworks.com">KrazyWorks</a> for Linux shared hosting environments. You can find detailed documantation about plugin <a href="http://www.krazyworks.com/support/diddle-widget-plugin/">here</a>. Quick configuration instructions: make the script executable by typing <code>chmod 755 diddle.ksh</code> in the plugin's directory. And while in that directory, note the path by typing <code>pwd</code>. You will need to enter the path/diddle.ksh into the Diddle widget configuration from the WordPress <a href="widgets.php">Widgets page</a>.
 * Version: 1.1.12
 * Author: KrazyWorks, LLC
 * Author URI: http://www.krazyworks.com/
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Initialize widget */
add_action( 'widgets_init', 'diddle_load_widget' );

/* Register widget */
function diddle_load_widget() {
	register_widget('diddle_widget');
}

/* Diddle widget class */
class diddle_widget extends WP_Widget {

	/* Diddle Widget setup. */
	function diddle_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'diddle', 'description' => __('Display server configuration and performance.', 'diddle') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'diddle-widget' );
		
		/* Create the widget. */
		$this->WP_Widget( 'diddle-widget', 'Diddle Widget', $widget_ops, $control_ops );
	}

	/* Screen display options. */
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$path = $instance['path'];

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title )
			echo $before_title . $title . $after_title;

		/* Display server information */
		if ( $path )
			$output = shell_exec($path);
	        echo "<pre>$output</pre>";

		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and path to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['path'] = strip_tags( $new_instance['path'] );

		return $instance;
	}

	/* Display widget settings controls on the widget panel. */
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 'title' => __('Server Info', 'diddle'), 'path' => __('/home/username/public_html/wp-content/plugins/diddle-widget/diddle.ksh', 'diddle') );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'hybrid'); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
		</p>

		<!-- Script path: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'path' ); ?>"><?php _e('Script path:', '/home/username/public_html/wp-content/plugins/diddle-widget/diddle.ksh'); ?></label>
			<input id="<?php echo $this->get_field_id( 'path' ); ?>" name="<?php echo $this->get_field_name( 'path' ); ?>" value="<?php echo $instance['path']; ?>" style="width:100%;" />
		</p>

	<?php
	}
}

?>
